// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.player.Notification;
import sk.tuke.fei.tukevian.domain.player.Player;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.web.game.PlayerController;

privileged aspect PlayerController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String PlayerController.create(@Valid Player player, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, player);
            return "players/create";
        }
        uiModel.asMap().clear();
        player.persist();
        return "redirect:/players/" + encodeUrlPathSegment(player.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String PlayerController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Player());
        return "players/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String PlayerController.show(@PathVariable("id") Long id, Model uiModel) {
        uiModel.addAttribute("player", Player.findPlayer(id));
        uiModel.addAttribute("itemId", id);
        return "players/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String PlayerController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("players", Player.findPlayerEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Player.countPlayers() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("players", Player.findAllPlayers(sortFieldName, sortOrder));
        }
        return "players/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String PlayerController.update(@Valid Player player, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, player);
            return "players/update";
        }
        uiModel.asMap().clear();
        player.merge();
        return "redirect:/players/" + encodeUrlPathSegment(player.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String PlayerController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Player.findPlayer(id));
        return "players/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String PlayerController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Player player = Player.findPlayer(id);
        player.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/players";
    }
    
    void PlayerController.populateEditForm(Model uiModel, Player player) {
        uiModel.addAttribute("player", player);
        uiModel.addAttribute("notifications", Notification.findAllNotifications());
        uiModel.addAttribute("villages", Village.findAllVillages());
    }
    
    String PlayerController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
