// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.joda.time.format.DateTimeFormat;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.player.Notification;
import sk.tuke.fei.tukevian.domain.player.Player;
import sk.tuke.fei.tukevian.web.game.NotificationController;

privileged aspect NotificationController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String NotificationController.create(@Valid Notification notification, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, notification);
            return "notifications/create";
        }
        uiModel.asMap().clear();
        notification.persist();
        return "redirect:/notifications/" + encodeUrlPathSegment(notification.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String NotificationController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Notification());
        return "notifications/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String NotificationController.show(@PathVariable("id") Long id, Model uiModel) {
        addDateTimeFormatPatterns(uiModel);
        uiModel.addAttribute("notification", Notification.findNotification(id));
        uiModel.addAttribute("itemId", id);
        return "notifications/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String NotificationController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("notifications", Notification.findNotificationEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Notification.countNotifications() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("notifications", Notification.findAllNotifications(sortFieldName, sortOrder));
        }
        addDateTimeFormatPatterns(uiModel);
        return "notifications/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String NotificationController.update(@Valid Notification notification, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, notification);
            return "notifications/update";
        }
        uiModel.asMap().clear();
        notification.merge();
        return "redirect:/notifications/" + encodeUrlPathSegment(notification.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String NotificationController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Notification.findNotification(id));
        return "notifications/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String NotificationController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Notification notification = Notification.findNotification(id);
        notification.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/notifications";
    }
    
    void NotificationController.addDateTimeFormatPatterns(Model uiModel) {
        uiModel.addAttribute("notification_notificationtime_date_format", DateTimeFormat.patternForStyle("M-", LocaleContextHolder.getLocale()));
    }
    
    void NotificationController.populateEditForm(Model uiModel, Notification notification) {
        uiModel.addAttribute("notification", notification);
        addDateTimeFormatPatterns(uiModel);
        uiModel.addAttribute("players", Player.findAllPlayers());
    }
    
    String NotificationController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
