// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.actions.BuildingType;
import sk.tuke.fei.tukevian.domain.forms.Build;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.web.game.BuildController;

privileged aspect BuildController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String BuildController.create(@Valid Build build, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, build);
            return "builds/create";
        }
        uiModel.asMap().clear();
        build.persist();
        return "redirect:/builds/" + encodeUrlPathSegment(build.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String BuildController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Build());
        return "builds/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String BuildController.show(@PathVariable("id") Long id, Model uiModel) {
        uiModel.addAttribute("build", Build.findBuild(id));
        uiModel.addAttribute("itemId", id);
        return "builds/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String BuildController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("builds", Build.findBuildEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Build.countBuilds() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("builds", Build.findAllBuilds(sortFieldName, sortOrder));
        }
        return "builds/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String BuildController.update(@Valid Build build, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, build);
            return "builds/update";
        }
        uiModel.asMap().clear();
        build.merge();
        return "redirect:/builds/" + encodeUrlPathSegment(build.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String BuildController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Build.findBuild(id));
        return "builds/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String BuildController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Build build = Build.findBuild(id);
        build.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/builds";
    }
    
    void BuildController.populateEditForm(Model uiModel, Build build) {
        uiModel.addAttribute("build", build);
        uiModel.addAttribute("buildingtypes", Arrays.asList(BuildingType.values()));
        uiModel.addAttribute("villages", Village.findAllVillages());
    }
    
    String BuildController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
