// WARNING: DO NOT EDIT THIS FILE. THIS FILE IS MANAGED BY SPRING ROO.
// You may push code into the target .java compilation unit if you wish to edit any member(s).

package sk.tuke.fei.tukevian.web.game;

import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.WebUtils;
import sk.tuke.fei.tukevian.domain.forms.Attack;
import sk.tuke.fei.tukevian.domain.village.Village;
import sk.tuke.fei.tukevian.web.game.AttackController;

privileged aspect AttackController_Roo_Controller {
    
    @RequestMapping(method = RequestMethod.POST, produces = "text/html")
    public String AttackController.create(@Valid Attack attack, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, attack);
            return "attacks/create";
        }
        uiModel.asMap().clear();
        attack.persist();
        return "redirect:/attacks/" + encodeUrlPathSegment(attack.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(params = "form", produces = "text/html")
    public String AttackController.createForm(Model uiModel) {
        populateEditForm(uiModel, new Attack());
        return "attacks/create";
    }
    
    @RequestMapping(value = "/{id}", produces = "text/html")
    public String AttackController.show(@PathVariable("id") Long id, Model uiModel) {
        uiModel.addAttribute("attack", Attack.findAttack(id));
        uiModel.addAttribute("itemId", id);
        return "attacks/show";
    }
    
    @RequestMapping(produces = "text/html")
    public String AttackController.list(@RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, @RequestParam(value = "sortFieldName", required = false) String sortFieldName, @RequestParam(value = "sortOrder", required = false) String sortOrder, Model uiModel) {
        if (page != null || size != null) {
            int sizeNo = size == null ? 10 : size.intValue();
            final int firstResult = page == null ? 0 : (page.intValue() - 1) * sizeNo;
            uiModel.addAttribute("attacks", Attack.findAttackEntries(firstResult, sizeNo, sortFieldName, sortOrder));
            float nrOfPages = (float) Attack.countAttacks() / sizeNo;
            uiModel.addAttribute("maxPages", (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages));
        } else {
            uiModel.addAttribute("attacks", Attack.findAllAttacks(sortFieldName, sortOrder));
        }
        return "attacks/list";
    }
    
    @RequestMapping(method = RequestMethod.PUT, produces = "text/html")
    public String AttackController.update(@Valid Attack attack, BindingResult bindingResult, Model uiModel, HttpServletRequest httpServletRequest) {
        if (bindingResult.hasErrors()) {
            populateEditForm(uiModel, attack);
            return "attacks/update";
        }
        uiModel.asMap().clear();
        attack.merge();
        return "redirect:/attacks/" + encodeUrlPathSegment(attack.getId().toString(), httpServletRequest);
    }
    
    @RequestMapping(value = "/{id}", params = "form", produces = "text/html")
    public String AttackController.updateForm(@PathVariable("id") Long id, Model uiModel) {
        populateEditForm(uiModel, Attack.findAttack(id));
        return "attacks/update";
    }
    
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE, produces = "text/html")
    public String AttackController.delete(@PathVariable("id") Long id, @RequestParam(value = "page", required = false) Integer page, @RequestParam(value = "size", required = false) Integer size, Model uiModel) {
        Attack attack = Attack.findAttack(id);
        attack.remove();
        uiModel.asMap().clear();
        uiModel.addAttribute("page", (page == null) ? "1" : page.toString());
        uiModel.addAttribute("size", (size == null) ? "10" : size.toString());
        return "redirect:/attacks";
    }
    
    void AttackController.populateEditForm(Model uiModel, Attack attack) {
        uiModel.addAttribute("attack", attack);
        uiModel.addAttribute("villages", Village.findAllVillages());
    }
    
    String AttackController.encodeUrlPathSegment(String pathSegment, HttpServletRequest httpServletRequest) {
        String enc = httpServletRequest.getCharacterEncoding();
        if (enc == null) {
            enc = WebUtils.DEFAULT_CHARACTER_ENCODING;
        }
        try {
            pathSegment = UriUtils.encodePathSegment(pathSegment, enc);
        } catch (UnsupportedEncodingException uee) {}
        return pathSegment;
    }
    
}
