package sk.tuke.fei.tukevian.domain.player;
import org.springframework.roo.addon.javabean.RooJavaBean;
import org.springframework.roo.addon.jpa.activerecord.RooJpaActiveRecord;
import org.springframework.roo.addon.tostring.RooToString;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.ManyToMany;
import sk.tuke.fei.tukevian.domain.village.Village;

@RooJavaBean
@RooToString
@RooJpaActiveRecord
public class Player {

    /**
     */
    @NotNull
    @Size(min = 3)
    private String name;

    /**
     */
    @ManyToMany(cascade = CascadeType.ALL)
    private Set<Notification> notifications = new HashSet<Notification>();

    /**
     */
    @ManyToMany(cascade = CascadeType.ALL)
    private Set<Village> villages = new HashSet<Village>();
}
